<?php

/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 22:23 - 03.04.21
 */

namespace cu\DataImport\Tests\UnitTests;

use cu\DataImport\DataImportException;
use cu\DataImport\DataInput\AggregatedDataInput;
use cu\DataImport\DataInput\CallbackDataInput;
use cu\DataImport\DataSource\CSVFileDataSource;
use cu\DataImport\DataSource\FileUploadAdapter\CSVFileUploadAdapter;
use cu\DataImport\DataSource\UploadedFileDataSource;
use cu\DataImport\Formatter\NullFormatter;
use cu\DataImport\Import;
use cu\DataImport\Validator\CallbackValidator;
use PHPUnit\Framework\TestCase;

/**
 * Class FileUploadTest
 *
 * @package cu\DataImport\Tests\UnitTests
 */
class FileUploadTest extends TestCase
{
    public const UPLOAD_DIR = '../../../../var/upload';

    /**
     * @var Import
     */
    private $subject;

    /**
     * @return void
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->subject = new Import();
    }

    /**
     * @throws DataImportException
     */
    public function testUploadImport(): void
    {
//        $_FILES['csv-upload'] = [
//            'name' => 'csv-upload.csv',
//            'tmp_name' => realpath('../../../../var/temp/upload.csv'),
//            'type' => 'text/csv'
//        ];

        $adapter = new CSVFileUploadAdapter();
        $adapter
            ->setSkipFirstLine()
            ->selectColumns(
                [
                    'fooBar1' => 5,
                    'fooBar2' => [
                        'colIndex' => 8,
                        'formatter' => NullFormatter::class
                    ],
                    'fooBar3'
                ]
            );

        $dataSource = new UploadedFileDataSource(
            $adapter,
            'csv-upload',
            self::UPLOAD_DIR
        );

        $this->subject->setDataSource($dataSource);

        $adapter->registerFormatterCallable(
            'fooBar2',
            function ($value) {
                return "Formatted by callback: " . $value;
            }
        );

        // TEST empty values
//        $this->subject->setDataSource(
//            new CSVFileDataSource(
//                static::SAMPLE_FILE,
//                [
//                    'fooBar1' => [
//                        'colIndex' => 40
//                    ],
//                    'fooBar2' => [
//                        'colIndex' => 41
//                    ],
//                    'fooBar3' => [
//                        'colIndex' => 41
//                    ]
//                ]
//            )
//        );


        $this->subject->registerValidatorInstance(
            'fooBar1',
            new CallbackValidator(
                [
                    'callback' => function ($value) {
                        return true;
                    }
                ]
            )
        );
        $this->subject->registerValidatorInstance(
            'fooBar3',
            new CallbackValidator(
                [
                    'callback' => function ($value) {
                        return true;
                    }
                ]
            )
        );

        $this->subject->setDataInput(
            new CallbackDataInput(
                function ($data) {
                    print_r($data);
                }
            )
        );


        $this->subject->import();

        $errors = $this->subject->getErrors();

//        print_r($errors);

        $this->assertEmpty($errors);
    }
}
