<?php

/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Interface IValidator
 *
 * @package cu\DataImport\Validator
 */
interface IValidator
{
    /**
     * @param mixed $value
     * @param int $rowIndex
     * @param int $colIndex
     * @return bool
     */
    public function validate($value, int $rowIndex, int $colIndex): bool;

    /**
     * @return ?string
     */
    public function getMessage(): ?string;
}
