<?php

/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class NotEmpty
 *
 * @package cu\DataImport\Validator
 */
class CallbackValidator extends AbstractValidator
{
    public const MESSAGE_KEY_CALLBACK_INVALID = 'callback_invalid';
    public const MESSAGE_KEY_VALUE_INVALID = 'value_invalid';
    public const MESSAGE_KEY_EMPTY_VALUE_INVALID = 'empty_value_invalid';

    /**
     * @var ?callable
     */
    private $callback;

    /**
     * @param callable $callback
     * @return $this
     */
    public function setCallback(callable $callback): CallbackValidator
    {
        $this->callback = $callback;

        return $this;
    }

    /**
     * @param mixed $value
     * @param int $rowIndex
     * @param int $colIndex
     * @return bool
     */
    public function validate($value, int $rowIndex, int $colIndex): bool
    {
        $this->reset();

        if (isset($this->callback) && is_callable($this->callback)) {
            if (true === call_user_func($this->callback, $value)) {
                return true;
            }

            if (!empty($value)) {
                $this->raiseError(static::MESSAGE_KEY_VALUE_INVALID, [$value, $rowIndex, $colIndex]);
            } else {
                $this->raiseError(static::MESSAGE_KEY_EMPTY_VALUE_INVALID, [$rowIndex, $colIndex]);
            }


            return false;
        }

        $this->raiseError(static::MESSAGE_KEY_CALLBACK_INVALID);

        return false;
    }
}
