<?php

/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 22:54 - 03.04.21
 */

namespace cu\DataImport\DataSource\FileUploadAdapter;

use cu\DataImport\DataSource\IDataSource;

/**
 * Interface IFileUploadAdapter
 *
 * @package cu\DataImport\DataSource
 */
interface IFileUploadAdapter extends IDataSource
{
    /**
     * @param string $sourceFile
     * @return void
     */
    public function setFile(string $sourceFile): void;

    /**
     * @param string $fileType
     * @return bool
     */
    public function canHandle(string $fileType): bool;

    /**
     * @param string $name
     * @return string
     */
    public function assembleFilename(string $name): string;
}
