<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 19:19 - 10.04.21
 */

namespace cu\DataImport\DataSource\FileUploadAdapter;

use cu\DataImport\DataSource\CSVFileDataSource;

/**
 * Class CSVFileUploadAdapter
 *
 * @package cu\DataImport\DataSource\FileUploadAdapter
 */
class CSVFileUploadAdapter extends CSVFileDataSource implements IFileUploadAdapter
{
    /**
     * @param string $fileType
     * @return bool
     */
    public function canHandle(string $fileType): bool
    {
        return 'text/csv' === $fileType;
    }

    /**
     * @inheritDoc
     */
    public function assembleFilename(string $name): string
    {
        return "{$name}.csv";
    }
}
