<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 23:30 - 09.04.21
 */

namespace cu\DataImport\DataInput;

/**
 * Class AggregatedDataInput
 *
 * @package cu\DataImport\DataInput
 */
class AggregatedDataInput extends AbstractDataInput
{
    /**
     * @var array<array<string,mixed>>
     */
    private $data = [];

    /**
     * @var callable
     */
    private $callback;

    /**
     * AggregatedDataInput constructor.
     *
     * @param callable $callback
     */
    public function __construct(callable $callback)
    {
        $this->callback = $callback;
    }

    /**
     * @inheritDoc
     */
    public function import($data): void
    {
        $this->data[] = $data;
    }

    /**
     * @inheritDoc
     */
    public function flush(): void
    {
        parent::flush();

        call_user_func($this->callback, $this->data);
    }
}
