<?php

/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 01:04 - 08.04.21
 */

namespace cu\DataImport;

use cu\DataImport\Validator\CallbackValidator;

/**
 * Class Translator
 *
 * @package cu\DataImport
 */
class Translator implements ITranslator
{
    /**
     * @var array<string,string>
     */
    private static $translations = [
        CallbackValidator::MESSAGE_KEY_VALUE_INVALID =>
            "Callback reported value '%s' to be invalid in row: %s, column: %s.",
        CallbackValidator::MESSAGE_KEY_EMPTY_VALUE_INVALID =>
            "Callback reported empty value to be invalid in row: %s, column: %s."
    ];

    /**
     * @var ITranslator
     */
    private static $translator;

    /**
     * @return ITranslator
     */
    public static function initTranslator(): ITranslator
    {
        if (!isset(static::$translator)) {
            static::$translator = new self();
        }

        return static::$translator;
    }

    /**
     * @param ITranslator $translator
     */
    public static function registerTranslator(ITranslator $translator): void
    {
        static::$translator = $translator;
    }

    /**
     * @inheritDoc
     */
    public function translateKey(string $key, ?array $data = null): string
    {
        if (isset(static::$translations[$key])) {
            if (!empty($data)) {
                return sprintf(static::$translations[$key], ...$data);
            }
            return static::$translations[$key];
        }

        return $key;
    }
}
