<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 00:23 - 04.04.21
 */

namespace cu\DataImport\DataInput;

/**
 * Interface IDataInput
 *
 * @package cu\DataImport\DataInput
 */
interface IDataInput
{
    /**
     * @return void
     */
    public function begin(): void;

    /**
     * @return void
     */
    public function flush(): void;

    /**
     * @return void
     */
    public function cancel(): void;

    /**
     * @param mixed $data
     * @return void
     */
    public function import($data): void;
}
