<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 00:52 - 04.04.21
 */

namespace cu\DataImport\Iterator;

/**
 * Class CSVFileIterator
 *
 * @package cu\DataImport\Iterator
 */
class CSVFileIterator implements \Iterator
{
    /**
     * @var string
     */
    private $pathToSourceFile;

    /**
     * @var resource
     */
    private $resourceHandle;

    /**
     * @var int
     */
    private $lineNumber = 0;

    /**
     * @var string
     */
    private $currentValue;

    /**
     * CSVFileIterator constructor.
     *
     * @param string $pathToSourceFile
     */
    public function __construct(string $pathToSourceFile)
    {
        $this->pathToSourceFile = $pathToSourceFile;
    }

    /**
     * @inheritDoc
     */
    public function current()
    {
        return $this->currentValue;
    }

    /**
     * @inheritDoc
     */
    public function next()
    {
    }

    /**
     * @inheritDoc
     */
    public function key()
    {
        return $this->lineNumber;
    }

    /**
     * @inheritDoc
     */
    public function valid(): bool
    {
        if (!is_resource($this->resourceHandle)) {
            return false;
        }

        if (!feof($this->resourceHandle)) {
            $line = fgetcsv($this->resourceHandle);
            if (null !== $line && false !== $line) {
                $this->currentValue = $line;
                $this->lineNumber++;
                return true;
            }
        }

        @fclose($this->resourceHandle);
        return false;
    }

    /**
     * @inheritDoc
     */
    public function rewind()
    {
        if (!empty($this->resourceHandle)) {
            @fclose($this->resourceHandle);
            unset($this->resourceHandle);
        }

        $this->resourceHandle = fopen($this->pathToSourceFile, 'r');
        $this->lineNumber = 0;
    }
}
