<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 22:54 - 03.04.21
 */

namespace cu\DataImport\DataSource;

/**
 * Class SimpleArrayDataSource
 *
 * @package cu\DataImport\DataSource
 */
class SimpleArrayDataSource implements IDataSource
{
    /**
     * @var array
     */
    private $data = [];

    /**
     * SimpleArrayDataSource constructor.
     *
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->data = $data;
    }

    /**
     * @inheritDoc
     */
    public function getData(): \Traversable
    {
        return new \ArrayIterator($this->data);
    }
}
