<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 22:23 - 03.04.21
 */

namespace cu\DataImport\Tests\UnitTests;

use cu\DataImport\DataImportException;
use cu\DataImport\DataInput\CallbackDataInput;
use cu\DataImport\DataSource\CSVFileDataSource;
use cu\DataImport\DataSource\IDataSource;
use cu\DataImport\Import;
use cu\DataImport\Validator\CallbackValidator;
use cu\DataImport\Validator\NotEmptyValidator;
use PHPUnit\Framework\TestCase;

/**
 * Class ImportTest
 *
 * @package cu\DataImport\Tests\UnitTests
 */
class ImportTest extends TestCase
{
    const SAMPLE_FILE = '../../../../resources/sample.csv';

    /**
     * @var Import
     */
    private $subject;

    /**
     * @return void
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->subject = new Import();
    }

    /**
     * @throws DataImportException
     */
    public function testImportThrowsExceptionWhenDataSourceIsMissing()
    {
        $this->expectException(DataImportException::class);
        $this->expectExceptionMessage("Datasource missing.");

        $this->subject->import();
    }

    /**
     * @throws DataImportException
     */
    public function testImportThrowsExceptionWhenDataInputIsMissing()
    {
        $this->expectException(DataImportException::class);
        $this->expectExceptionMessage("Data input missing.");

        $this->subject->setDataSource($this->createStub(IDataSource::class));

        $this->subject->import();
    }

    /**
     * @throws DataImportException
     */
    public function testImport()
    {
//        $this->subject->configureColumns(
//            [
//                [
//                    'label' => 'Foo',
//                    'reference' => 0,
//                    'validators' => [
//                        NotEmptyValidator::class
//                    ]
//                ]
//            ]
//        );

        $this->subject->setDataInput(
            new CallbackDataInput(
                function ($data) {
//                    var_dump($data);
                }
            )
        );

//        $this->subject->registerValidator(
//            new CallbackValidator(
//                function ($value) {
////                    var_dump($value);
//                    return true;
//                }
//            ),
//            1
//        );

        $this->subject->setDataSource(
            new CSVFileDataSource(static::SAMPLE_FILE)
        );

        $this->subject->import();

        $errors = $this->subject->getErrors();

        $this->assertEmpty($errors);
    }
}
