<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class NumericIntervalValidator
 *
 * @package cu\DataImport\Validator
 */
class NumericIntervalValidator extends AbstractValidator
{
    public const MESSAGE_KEY_VALUE_OUT_OF_RANGE = 'value_out_of_range';
    public const MESSAGE_KEY_VALUE_NOT_OF_NUMERIC_TYPE = 'value_not_of_numeric_type';

    /**
     * @var int
     */
    private $min;

    /**
     * @var int
     */
    private $max;

    /**
     * @param array $interval
     *
     * @return $this
     */
    public function setInterval(int $min, int $max): NumericIntervalValidator
    {
        $this->min = $min;
        $this->max = $max;

        return $this;
    }

    /**
     * @param mixed $value
     *
     * @return bool
     */
    public function isValid($value): bool
    {
        $this->clearAllErrors();

        if (is_numeric($value)) {
            $value = (int)$value;
            if (isset($this->min) && isset($this->max)
                && ($this->min < $value && $this->max > $value)) {
                return true;
            } elseif (isset($this->min) && $this->min < $value) {
                return true;
            } elseif (isset($this->max) && $this->max > $value) {
                return true;
            }

            $this->raiseError(static::MESSAGE_KEY_VALUE_OUT_OF_RANGE, [$value, $this->min, $this->max]);
        }


        $this->raiseError(static::MESSAGE_KEY_VALUE_NOT_OF_NUMERIC_TYPE, [$value]);
    }
}
