<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 22:54 - 03.04.21
 */

namespace cu\DataImport\DataSource;

use cu\DataImport\Iterator\CSVFileIterator;

/**
 * Class CSVFileDataSource
 *
 * @package cu\DataImport\DataSource
 */
class CSVFileDataSource implements IFileDataSource
{
    /**
     * @var string
     */
    private $pathToSourceFile;

    /**
     * CSVFileDataSource constructor.
     *
     * @param ?string $pathToSourceFile
     */
    public function __construct(?string $pathToSourceFile)
    {
        if ($pathToSourceFile) {
            $this->setFile($pathToSourceFile);
        }
    }

    /**
     * @param $pathToSourceFile
     *
     * @return void
     */
    public function setFile(string $pathToSourceFile): void
    {
        $this->pathToSourceFile = $pathToSourceFile;
    }

    /**
     * @param string $fileType
     * @return bool
     */
    public function canHandle(string $fileType): bool
    {
        return 'csv' === $fileType;
    }

    /**
     * @inheritDoc
     */
    public function getData(): \Traversable
    {
        return new CSVFileIterator($this->pathToSourceFile);
    }
}
