<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class AbstractValidator
 *
 * @package cu\DataImport\Validator
 */
abstract class AbstractValidator implements IValidator
{
    /**
     * @var array
     */
    protected $options;

    /**
     * @var string
     */
    private $name;

    /**
     * @var array<string>
     */
    protected $messages = [];

    /**
     * AbstractValidator constructor.
     *
     * @param $options
     */
    public function __construct($options)
    {
        $this->setOptions($options);
    }

    /**
     * @return AbstractValidator
     */
    protected function clearAllErrors(): AbstractValidator
    {
        $this->messages = [];

        return $this;
    }

    /**
     * @param string $messageKey
     * @param ?array $data
     * @return ?string
     */
    protected function raiseError(string $messageKey, ?array $data = null): ?string
    {
        return $this->messages[] = $messageKey; // TODO: translate
    }

    /**
     * @inheritDoc
     */
    public function getMessages(): array
    {
        return $this->messages;
    }

    /**
     * @param string $name
     * @param mixed $default
     *
     * @return mixed
     */
    public function get(string $name, $default = null)
    {
        return $this->options[$name] ?: $default;
    }

    /**
     * @param array $options
     *
     * @return AbstractValidator
     */
    public function setOptions(array $options = array()): AbstractValidator
    {
        $this->options = array_filter(
            $options,
            function ($val, $key) {
                $method = "set" . ucfirst($key);
                if (method_exists($this, $method)) {
                    $this->{$method}($val);

                    return true;
                }

                return false;
            },
            ARRAY_FILTER_USE_BOTH
        );

        return $this;
    }

    /**
     * @param string $name
     *
     * @return AbstractValidator
     */
    public function setName(string $name): AbstractValidator
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return ?string
     */
    public function getName(): ?string
    {
        return $this->name;
    }
}
