<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class NotEmptyValidator
 *
 * @package cu\DataImport\Validator
 */
class NotEmptyValidator extends AbstractValidator
{
    public const MESSAGE_KEY_VALUE_WAS_EMPTY = 'value_was_empty';

    /**
     * @param mixed $value
     *
     * @return bool
     */
    public function isValid($value): bool
    {
        $this->clearAllErrors();

        if (!empty($value)) {
            return true;
        }

        $this->raiseError(static::MESSAGE_KEY_VALUE_WAS_EMPTY);
    }
}
