<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class NotEmpty
 *
 * @package cu\DataImport\Validator
 */
class CallbackValidator extends AbstractValidator
{
    public const MESSAGE_KEY_VALUE_INVALID = 'value_invalid';

    /**
     * @var callable
     */
    private $callback;

    /**
     * CallbackDataInput constructor.
     *
     * @param callable $callback
     */
    public function __construct(callable $callback)
    {
        $this->callback = $callback;
    }

    /**
     * @param mixed $value
     *
     * @return bool
     */
    public function isValid($value): bool
    {
        $this->clearAllErrors();

        if (true === call_user_func($this->callback, $value)) {
            return true;
        }

        $this->raiseError(static::MESSAGE_KEY_VALUE_INVALID, [$value]);

        return false;
    }
}
