<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 23:30 - 07.04.21
 */

namespace cu\DataImport\DataSource;

use cu\DataImport\DataImportException;

/**
 * Trait ColumnSpecTrait
 *
 * @package cu\DataImport\DataSource
 */
trait ColumnSpecTrait
{
    /**
     * @param ?array $initialColSpec
     * @return array
     * @throws DataImportException
     */
    protected function assembleColSpec(?array $initialColSpec): array
    {
        $finalColSpec = [];
        $colIndex = 1;
        foreach ($initialColSpec as $colName => $colSpec) {
            if (is_string($colName)) {
                if (is_int($colSpec)) {
                    $finalColSpec[$colName] = [
                        'colIndex' => $colIndex = $colSpec
                    ];
                } elseif (is_array($colSpec)) {
                    if (!isset($colSpec['colIndex'])) {
                        $colSpec['colIndex'] = $colIndex;
                    } else {
                        $colSpec['colIndex'] = $colIndex = (int)$colSpec['colIndex'];
                    }

                    $finalColSpec[$colName] = $colSpec;
                } else {
                    throw new DataImportException('Invalid col spec.');
                }
            } elseif (is_string($colSpec)) {
                $finalColSpec[$colSpec] = [
                    'colIndex' => $colIndex
                ];
            } else {
                throw new DataImportException('Invalid col spec.');
            }

            $colIndex += 1;
        }

        return $finalColSpec;
    }
}
