<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 22:23 - 03.04.21
 */

namespace cu\DataImport\Tests\UnitTests;

use cu\DataImport\DataImportException;
use cu\DataImport\DataInput\CallbackDataInput;
use cu\DataImport\DataSource\CSVFileDataSource;
use cu\DataImport\DataSource\IDataSource;
use cu\DataImport\Import;
use cu\DataImport\Validator\CallbackValidator;
use cu\DataImport\Validator\NotEmptyValidator;
use cu\DataImport\Validator\NumericIntervalValidator;
use PHPUnit\Framework\TestCase;

/**
 * Class ImportTest
 *
 * @package cu\DataImport\Tests\UnitTests
 */
class ImportTest extends TestCase
{
//    const SAMPLE_FILE = '../../../../resources/sample.csv';
    const SAMPLE_FILE = '../../../../resources/sample-empty-col-test.csv';

    /**
     * @var Import
     */
    private $subject;

    /**
     * @return void
     */
    protected function setUp(): void
    {
        parent::setUp();

        $this->subject = new Import();
    }

    /**
     * @throws DataImportException
     */
    public function testImportThrowsExceptionWhenDataSourceIsMissing()
    {
        $this->expectException(DataImportException::class);
        $this->expectExceptionMessage("Datasource missing.");

        $this->subject->import();
    }

    /**
     * @throws DataImportException
     */
    public function testImportThrowsExceptionWhenDataInputIsMissing()
    {
        $this->expectException(DataImportException::class);
        $this->expectExceptionMessage("Data input missing.");

        $this->subject->setDataSource($this->createStub(IDataSource::class));

        $this->subject->import();
    }

    /**
     * @throws DataImportException
     */
    public function testImport()
    {
        $dataSource = new CSVFileDataSource(
            static::SAMPLE_FILE,
            [
                'fooBar1' => 5,
                'fooBar2' => [
                    'colIndex' => 8
                ],
                'fooBar3'
            ]
        );

        $dataSource->setSkipFirstLine();

        $this->subject->setDataSource(
            $dataSource
        );


        // TEST empty values
//        $this->subject->setDataSource(
//            new CSVFileDataSource(
//                static::SAMPLE_FILE,
//                [
//                    'fooBar1' => [
//                        'colIndex' => 40
//                    ],
//                    'fooBar2' => [
//                        'colIndex' => 41
//                    ],
//                    'fooBar3' => [
//                        'colIndex' => 41
//                    ]
//                ]
//            )
//        );


        $this->subject->registerValidator(
            'fooBar1',
            new CallbackValidator(
                [
                    'callback' => function ($value) {
//                        echo "Validating: ", $value, PHP_EOL;
                        return false;
                    }
                ]
            )
        );
        $this->subject->registerValidator(
            'fooBar3',
            new CallbackValidator(
                [
                    'callback' => function ($value) {
//                        echo "Validating: ", $value, PHP_EOL;
                        return false;
                    }
                ]
            )
        );

        $this->subject->setDataInput(
            new CallbackDataInput(
                function ($data) {
//                    print_r($data);
                }
            )
        );

        $this->subject->import();

        $errors = $this->subject->getErrors();

        print_r($errors);

        $this->assertEmpty($errors);
    }
}
