<?php

/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 00:23 - 04.04.21
 */

namespace cu\DataImport\DataInput;

/**
 * Class CallbackDataInput
 *
 * @package cu\DataImport\DataInput
 */
class CallbackDataInput extends AbstractDataInput
{
    /**
     * @var callable
     */
    private $callback;

    /**
     * CallbackDataInput constructor.
     *
     * @param callable $callback
     */
    public function __construct(callable $callback)
    {
        $this->callback = $callback;
    }

    /**
     * @inheritDoc
     */
    public function import($data): void
    {
        call_user_func($this->callback, $data);
    }
}
