<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 22:23 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class RegexValidator
 *
 * @package cu\DataImport\Validator
 */
class RegexValidator extends AbstractValidator
{
    public const MESSAGE_KEY_NOT_MATCHES_REGEX = 'not_matches_regex';

    /**
     * RegexValidator constructor.
     *
     * @param string $regex
     */
    public function __construct(string $regex)
    {
        parent::__construct(
            [
                'regex' => $regex
            ]
        );
    }

    /**
     * @inheritDoc
     */
    public function isValid($value): bool
    {
        $this->reset();

        if (preg_match($this->get('regex'), $value)) {
            return true;
        }

        $this->raiseError(static::MESSAGE_KEY_NOT_MATCHES_REGEX);

        return false;
    }
}
