<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class NotEmpty
 *
 * @package cu\DataImport\Validator
 */
class CallbackValidator extends AbstractValidator
{
    public const MESSAGE_KEY_VALUE_INVALID = 'value_invalid';

    /**
     * @var callable
     */
    private $callback;

    /**
     * @param callable $callback
     * @return $this
     */
    public function setCallback(callable $callback): CallbackValidator
    {
        $this->callback = $callback;

        return $this;
    }

    /**
     * @param mixed $value
     *
     * @return bool
     */
    public function isValid($value): bool
    {
        $this->reset();

        if (is_callable($this->callback)) {
            if (true === call_user_func($this->callback, $value)) {
                return true;
            }

            $this->raiseError(static::MESSAGE_KEY_VALUE_INVALID);

            return false;
        }

        // TODO: replace by invalid status with message key!
        throw new ValidationException('Invalid callback.');
    }
}
