<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author    chris <chris@softwarewerk.de>
 * Creationtime: 00:07 - 04.04.21
 */

namespace cu\DataImport\Validator;

/**
 * Class AbstractValidator
 *
 * @package cu\DataImport\Validator
 */
abstract class AbstractValidator implements IValidator
{
    /**
     * @var array
     */
    protected $options;

    /**
     * @var ?string
     */
    protected $messageKey;

    /**
     * AbstractValidator constructor.
     *
     * @param $options
     */
    public function __construct(?array $options = null)
    {
        $this->setOptions($options);
    }

    /**
     * @return AbstractValidator
     */
    protected function reset(): AbstractValidator
    {
        $this->messageKey = null;

        return $this;
    }

    /**
     * @param string $messageKey
     */
    protected function raiseError(string $messageKey): void
    {
        $this->messageKey = $messageKey;
    }

    /**
     * @inheritDoc
     */
    public function getMessageKey(): string
    {
        return $this->messageKey;
    }

    /**
     * @param string $name
     * @param mixed $default
     *
     * @return mixed
     */
    public function get(string $name, $default = null)
    {
        return $this->options[$name] ?: $default;
    }

    /**
     * @param ?array $options
     *
     * @return AbstractValidator
     */
    public function setOptions(?array $options = null): AbstractValidator
    {
        if (empty($options)) {
            $this->options = [];
        } else {
            $this->options = array_filter(
                $options,
                function ($val, $key) {
                    $method = "set" . ucfirst($key);
                    if (method_exists($this, $method)) {
                        if (is_array($val)) {
                            $this->{$method}(...$val);
                        } else {
                            $this->{$method}($val);
                        }


                        return true;
                    }

                    return false;
                },
                ARRAY_FILTER_USE_BOTH
            );
        }

        return $this;
    }
}
