<?php
/**
 * @copyright softwarewerk <info@softwarewerk.de>
 * @author chris <chris@softwarewerk.de>
 * Creationtime: 01:04 - 08.04.21
 */

namespace cu\DataImport;

use cu\DataImport\Validator\CallbackValidator;

/**
 * Class Translator
 *
 * @package cu\DataImport
 */
class Translator implements ITranslator
{
    private static $translations = [
        CallbackValidator::MESSAGE_KEY_VALUE_INVALID => "Callback reported value '%s' to be invalid in location %s, %s."
    ];

    /**
     * @inheritDoc
     */
    public function translateKey(string $key, ?array $data = null): string
    {
        if (isset(static::$translations[$key])) {
            return sprintf(static::$translations[$key], ...$data);
        }

        return $key;
    }
}
